package gov.va.med.mhv.admin.service.impl.mhvusers;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.HtmlEmail;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import org.owasp.esapi.ESAPI;

import gov.va.med.mhv.admin.dto.EmailDTO;
import gov.va.med.mhv.admin.exception.EmailFailureException;
import gov.va.med.mhv.admin.handler.MviProperties;
import gov.va.med.mhv.admin.service.mhvusers.EmailService;

@Path("/")
@Service("emailService")
@Component
public class EmailServiceImpl implements EmailService {

	private static final Log LOG = LogFactory.getLog(EmailServiceImpl.class);

	@Autowired
	private MviProperties mviProperties;
	private static final String EMAIL_DELIM_CHAR = ",";

	@POST
	@Consumes("application/json")
	@Produces("application/json")
	@Path("/sendTempEmail")
	public void sendTempEmail(EmailDTO emailDto) throws EmailFailureException {
		HtmlEmail htmlEmail = new HtmlEmail();

		try {
		    Map<String,String> headers=new HashMap<String,String>();
		    headers.put("content","text/html; charset=ISO-8859-1");
		    htmlEmail.setHeaders(headers);
			htmlEmail.setSubject(emailDto.getSubject());
			htmlEmail.setHostName(mviProperties.getSmtpHost());
			htmlEmail.setDebug(mviProperties.getSmtpDebug());
			String message = ESAPI.encoder().encodeForHTML(emailDto.getMessage());
			htmlEmail.setHtmlMsg(ESAPI.encoder().decodeForHTML(message));
			//htmlEmail.setHtmlMsg(emailDto.getMessage());
			StringTokenizer toTok = new StringTokenizer(emailDto.getRecipient(), EMAIL_DELIM_CHAR);
			while (toTok.hasMoreTokens()) {
				htmlEmail.addTo(ESAPI.encoder().canonicalize(toTok.nextToken()));
				//htmlEmail.addTo(toTok.nextToken());
			}
			htmlEmail.setFrom(emailDto.getFrom());
			//htmlEmail.setMsg(message);
			//htmlEmail.setHtmlMsg(emailDto.getMessage());
			htmlEmail.send();
		} catch (Exception e) {
			//String errMsg = String.format("AdminPortal: Error sending message: %s", e.getMessage());
			LOG.error("AdminPortal: Error sending an email");
			throw new EmailFailureException("AdminPortal: Error sending an email");
		}
	}
}

